/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.summary;

import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkMilestone;
import filenet.vw.toolkit.runtime.VWTrkStep;
import filenet.vw.toolkit.runtime.summary.images.VWImageLoader;
import filenet.vw.toolkit.runtime.summary.resources.VWResource;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWPropertyChangeNotifier;
import java.util.Date;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.table.AbstractTableModel;

public class VWMilestoneHistoryTableModel
extends AbstractTableModel
implements IVWPropertyChangeListener {
    public static final int MILESTONE_REACHED_COL = 0;
    public static final int MILESTONE_NAME_COL = 1;
    public static final int MILESTONE_MAP_NAME_COL = 2;
    public static final int MILESTONE_STEP_NAME_COL = 3;
    public static final int MILESTONE_MESSAGE_COL = 4;
    public static final int MILESTONE_LEVEL_COL = 5;
    public static final int MILESTONE_REACHED_DATE_COL = 6;
    private ImageIcon m_collapseIcon = VWImageLoader.createImageIcon("collapse.gif");
    private ImageIcon m_expandIcon = VWImageLoader.createImageIcon("expand.gif");
    private JLabel m_check = new JLabel(VWImageLoader.createImageIcon("check.gif"));
    protected VWTrkDataModel m_trackerDataModel = null;
    private Vector m_columnNames = new Vector();
    private Vector m_milestones = null;
    private boolean[] m_bShowDetails = null;
    private int m_maxLevel = 1;

    public VWMilestoneHistoryTableModel(VWTrkDataModel trackerDataModel) {
        this.m_trackerDataModel = trackerDataModel;
        this.initColumnNames();
        this.m_milestones = this.m_trackerDataModel.getMilestones();
        this.m_bShowDetails = new boolean[this.m_milestones.size()];
        for (int i = 0; i < this.m_bShowDetails.length; ++i) {
            this.m_bShowDetails[i] = false;
        }
        VWPropertyChangeNotifier.addPropertyChangeListener(this);
    }

    VWTrkDataModel getDataModel() {
        return this.m_trackerDataModel;
    }

    void initData() {
        this.m_milestones = this.m_trackerDataModel.getMilestones();
        this.fireTableDataChanged();
    }

    public Object getValueAt(int row, int col) {
        if (this.m_milestones == null) {
            return null;
        }
        if (row >= this.getRowCount()) {
            return null;
        }
        int[] indices = new int[2];
        if (!this.rowToIndex(row, indices)) {
            return null;
        }
        VWTrkMilestone milestone = (VWTrkMilestone)this.m_milestones.elementAt(indices[0]);
        if (milestone == null) {
            return null;
        }
        switch (col) {
            case 0: {
                if (milestone.isReached()) {
                    return this.m_check;
                }
                return null;
            }
            case 1: {
                if (indices[1] == 0 || indices[1] == -1) {
                    JLabel name = new JLabel(milestone.getName());
                    if (milestone.getHistorySize() > 1) {
                        if (this.m_bShowDetails[indices[0]]) {
                            name.setIcon(this.m_expandIcon);
                        } else {
                            name.setIcon(this.m_collapseIcon);
                        }
                    }
                    return name;
                }
                return null;
            }
            case 2: {
                return milestone.getReachedMapName(indices[1]);
            }
            case 3: {
                return milestone.getReachedStepName(indices[1]);
            }
            case 4: {
                return milestone.getMessage(indices[1]);
            }
            case 5: {
                return new Integer(milestone.getLevel());
            }
            case 6: {
                return milestone.getDate(indices[1]);
            }
        }
        return null;
    }

    protected void initColumnNames() {
        this.m_columnNames.addElement("");
        this.m_columnNames.addElement(VWResource.s_milestone);
        this.m_columnNames.addElement(VWResource.s_map);
        this.m_columnNames.addElement(VWResource.s_step);
        this.m_columnNames.addElement(VWResource.s_message);
        this.m_columnNames.addElement(VWResource.s_level);
        this.m_columnNames.addElement(VWResource.s_reached);
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Boolean.class;
            }
            case 1: 
            case 4: {
                return String.class;
            }
            case 5: {
                return Integer.class;
            }
            case 6: {
                return Date.class;
            }
        }
        return String.class;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public int getRowCount() {
        if (this.m_milestones == null) {
            return 0;
        }
        int count = 0;
        if (this.m_milestones != null) {
            for (int i = 0; i < this.m_milestones.size(); ++i) {
                VWTrkMilestone milestone;
                Object obj = this.m_milestones.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkMilestone) || (milestone = (VWTrkMilestone)obj).getLevel() > this.m_maxLevel) continue;
                if (this.m_bShowDetails[i]) {
                    int n = milestone.getHistorySize();
                    if (n == 0) {
                        n = 1;
                    }
                    count += n;
                    continue;
                }
                ++count;
            }
        }
        return count;
    }

    public int getColumnCount() {
        return this.m_columnNames.size();
    }

    public String getColumnName(int col) {
        if (col < this.getColumnCount()) {
            return (String)this.m_columnNames.elementAt(col);
        }
        return null;
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        if (event == null || this.m_milestones == null || this.m_milestones.size() == 0) {
            return;
        }
        Object obj = event.getSource();
        if (obj instanceof IVWPropertyChangeSource) {
            IVWPropertyChangeSource source = (IVWPropertyChangeSource)obj;
            if (source == null) {
                return;
            }
            Object items = null;
            int type = event.getID();
            switch (type) {
                case 704: 
                case 705: {
                    this.initData();
                }
            }
        }
    }

    boolean rowToIndex(int row, int[] indices) {
        if (indices == null || indices.length != 2) {
            return false;
        }
        int count = 0;
        indices[1] = -1;
        for (int i = 0; i < this.m_milestones.size(); ++i) {
            VWTrkMilestone milestone = (VWTrkMilestone)this.m_milestones.elementAt(i);
            if (milestone == null || milestone.getLevel() > this.m_maxLevel) continue;
            int inc = 1;
            if (this.m_bShowDetails[i]) {
                if (milestone.getHistorySize() > 0) {
                    inc = milestone.getHistorySize();
                }
                count += inc;
            } else {
                ++count;
            }
            if (row >= count) continue;
            indices[0] = i;
            if (this.m_bShowDetails[i]) {
                indices[1] = row - count + inc;
            }
            return true;
        }
        indices[0] = -1;
        indices[1] = -1;
        return false;
    }

    protected void toggleShowDetails(int row) {
        int[] indices = new int[2];
        if (this.rowToIndex(row, indices) && (indices[1] == 0 || indices[1] == -1)) {
            boolean bShow = this.m_bShowDetails[indices[0]];
            this.m_bShowDetails[indices[0]] = !bShow;
            this.fireTableDataChanged();
        }
    }

    protected void setMaxLevelShown(int level) {
        if (this.m_maxLevel == level) {
            return;
        }
        this.m_maxLevel = level;
        this.fireTableDataChanged();
    }

    Vector getMilestones() {
        return this.m_milestones;
    }

    VWTrkMilestone getMilestone(int row) {
        int[] indices = new int[2];
        if (!this.rowToIndex(row, indices)) {
            return null;
        }
        if (this.m_milestones != null && indices[0] >= 0 && indices[0] < this.m_milestones.size()) {
            return (VWTrkMilestone)this.m_milestones.elementAt(indices[0]);
        }
        return null;
    }

    VWTrkStep getStep(int row) {
        VWTrkMilestone milestone;
        int[] indices = new int[2];
        if (!this.rowToIndex(row, indices)) {
            return null;
        }
        if (this.m_milestones != null && indices[0] >= 0 && indices[0] < this.m_milestones.size() && (milestone = (VWTrkMilestone)this.m_milestones.elementAt(indices[0])) != null) {
            return milestone.getReachedStep(indices[1]);
        }
        return null;
    }

    public void removeReferences() {
        this.m_trackerDataModel = null;
        if (this.m_columnNames != null) {
            this.m_columnNames.removeAllElements();
            this.m_columnNames = null;
        }
        this.m_milestones = null;
        VWPropertyChangeNotifier.removePropertyChangeListener(this);
    }
}

